<?php



$vbulletin->input->clean_array_gpc('g', array(
	'type'      =>  TYPE_STR,
	'perpage'   => TYPE_INT,
	'page'      => TYPE_INT
));

$type       = $vbulletin->GPC['type'];
$perpage    = $vbulletin->GPC['perpage'];
$page       = $vbulletin->GPC['page'];

if (!$page) {
	$page = 1;
}

if (!$perpage) {
	$perpage = 25;
}

$start  = ($page - 1) * $perpage;
$end    = $perpage;

$denycats = array();

foreach ($vbulletin->dbtech_downloads_categories AS $catid => $category) {
	$permissions    = unserialize($category['permissions']);
	$secondary      = explode(',', $vbulletin->userinfo['membergroupids']);
	$canview        = false;

	foreach ($secondary AS $usergroupid) {
		if (in_array($secondary, (array)$permissions['view'])) {
			$canview = true;
		}
	}
	
	if ($canview == false && !in_array($vbulletin->userinfo['usergroupid'], (array)$permissions['view'])) {
		$denycats[] = $category['catid'];
	}
}

$total = $db->query_first("
	SELECT COUNT(groupid) AS total FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup
	WHERE categoryid NOT IN ('" . implode(',', $denycats) . "')
");

$total = $total['total'];

switch ($type) {
	case 'downloads':
        $SQL = "
            SELECT g.*, u.username FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup AS g
            LEFT JOIN " . TABLE_PREFIX . "user AS u USING (userid)
            WHERE g.categoryid NOT IN ('" . implode(',', $denycats) . "')
            ORDER BY g.downloads DESC
            LIMIT $start, $end
        ";
    break;

	case 'rating':
        $SQL = "
            SELECT g.*, u.username FROM " . TABLE_PREFIX."dbtech_downloads_filegroup AS g
            LEFT JOIN " . TABLE_PREFIX . "user AS u USING (userid)
            WHERE g.categoryid NOT IN ('" . implode(',', $denycats). "')
            ORDER BY g.rating DESC
            LIMIT $start, $end
        ";
    break;
	
	default:
        $SQL = "
            SELECT g.*, u.username FROM " . TABLE_PREFIX ."dbtech_downloads_filegroup AS g
            LEFT JOIN " . TABLE_PREFIX . "user AS u USING (userid)
            WHERE g.categoryid NOT IN ('" . implode(',', $denycats) . "')
            ORDER BY g.updated DESC
            LIMIT $start, $end
        ";
    break;   
}

if (!$type) {
	$type = $vbphrase['dbtech_downloads_newest_files'];
}

if ($SQL) {
	require_once (DIR . '/includes/class_bbcode.php');
	
	$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list());
	
	$getResults = $db->query_read($SQL);

	$searchbits = '';
	while ($results = $db->fetch_array($getResults)) {
		$bits = vB_Template::create('dbtech_downloads_search_bits');

		$results['updated'] = vbdate('M jS Y \a\t h:i a', $results['updated'], true, false);
		$results['rating']  = Downloads::beautify_rating($results['rating']);
		
		$results['groupdesc'] = $bbcode->parse(strip_tags(Downloads::convert_wysiwyg_html_to_bbcode($results['groupdesc'])), 'nonforum', true, false);
		
		$bits->register('search', $results);

		$searchbits .= $bits->render();
	}
}

$navbits[] = $vbphrase['dbtech_downloads_search'];

$pagenavhtml = construct_page_nav($page, $perpage, $total, $vbulletin->options['dbtech_downloads_link'] . '.php?do=search', '&perpage=' . $perpage . '&type=' .$type);

$search = vB_Template::create('dbtech_downloads_search');

$search->register('searchbits', $searchbits);
$search->register('type', ucfirst($type));
$search->register('pagenav', $pagenavhtml);

$HTML .= $search->render();


?>